<?php
/**
 * @version $Id: asbruwce.php,v 1.3 2008/10/24 01:00:21 admin Exp $
 * modified version of:
 * @version		$Id: asbruwce.php,v 1.3 2008/10/24 01:00:21 admin Exp $
 * @package		Joomla
 * @copyright	Copyright (C) 2005 - 2007 Open Source Matters. All rights reserved.
 * @license		GNU/GPL, see LICENSE.php
 * Joomla! is free software. This version may have been modified pursuant
 * to the GNU General Public License, and as distributed it includes or
 * is derivative of works licensed under the GNU General Public License or
 * other free or open source software licenses.
 * See COPYRIGHT.php for copyright notices and details.
 */

// Do not allow direct access
defined( '_JEXEC' ) or die( 'Restricted access' );

jimport( 'joomla.plugin.plugin' );

/**
 * Asbru Web Content Editor Plugin
 *
 * @author Louis Landry <louis.landry@joomla.org>
 * @package Editors
 * @since 1.5
 */
class plgEditorAsbruwce extends JPlugin
{
	/**
	 * Constructor
	 *
	 * For php4 compatability we must not use the __constructor as a constructor for plugins
	 * because func_get_args ( void ) returns a copy of all passed arguments NOT references.
	 * This causes problems with cross-referencing necessary for the observer design pattern.
	 *
	 * @param 	object $subject The object to observe
	 * @param 	array  $config  An array that holds the plugin configuration
	 * @since 1.5
	 */
	function plgEditorAsbruwce(& $subject, $config) {
		$this->joomla_path = "";
		if ($_SERVER['SCRIPT_FILENAME']) {
			$this->joomla_path = str_replace("\\", "/", str_replace($_SERVER['DOCUMENT_ROOT'], "", $_SERVER['SCRIPT_FILENAME']));
		} else if ($_SERVER['ORIG_PATH_TRANSLATED']) {
			$this->joomla_path = str_replace("\\", "/", str_replace($_SERVER['DOCUMENT_ROOT'], "", $_SERVER['ORIG_PATH_TRANSLATED']));
		}
		$this->joomla_path = substr($this->joomla_path, 0, strpos($this->joomla_path, "/administrator/"));
		if (($this->joomla_path <> "") && (substr($this->joomla_path, 0, 1) <> "/")) {
			$this->joomla_path = "/" . $this->joomla_path;
		}
		parent::__construct($subject, $config);
	}

	/**
	 * Method to handle the onInit event.
	 *  - Initializes the Asbru Web Content Editor
	 *
	 * @access public
	 * @return string JavaScript Initialization string
	 * @since 1.5
	 */
	function onInit()
	{
		return <<<EOD
<script type="text/javascript" src="$this->joomla_path/webeditor/webeditor.js"></script>
<script type="text/javascript">
function webeditor_custom_save() {
	submitbutton('save');
}
</script>
<style type="text/css">
table.adminform td .webeditor_toolbar td {
	padding: 0px;
}
</style>
EOD;

	}

	/**
	 * Asbru Web Content Editor - get the editor content
	 *
	 * @param string 	The name of the editor
	 */
	function onGetContent( $editor ) {
		return "WebEditorGetContent(" . $editor . ");";
	}

	/**
	 * Asbru Web Content Editor - set the editor content
	 *
	 * @param string 	The name of the editor
	 */
	function onSetContent( $editor, $html ) {
		return "WebEditorSetContent(" . $html . ", " . $editor . ");";
	}

	/**
	 * Asbru Web Content Editor - copy editor content to form field
	 *
	 * @param string 	The name of the editor
	 */
	function onSave( $editor ) {
		return "WebEditorSubmit();";
	}

	/**
	 * Asbru Web Content Editor - display the editor
	 *
	 * @param string The name of the editor area
	 * @param string The content of the field
	 * @param string The width of the editor area
	 * @param string The height of the editor area
	 * @param int The number of columns for the editor area
	 * @param int The number of rows for the editor area
	 * @param mixed Can be boolean or array.
	 */
	function onDisplay( $name, $content, $width, $height, $col, $row, $buttons = true)
	{
		$db			=& JFactory::getDBO();
		$language	=& JFactory::getLanguage();

#		$stylesheet 			= $this->params->get( 'stylesheet', '/webeditor/example.css' );
		$stylesheet 			= $this->params->get( 'stylesheet', '' );
		$manager 			= $this->params->get( 'manager', '' );
		$onenter 			= $this->params->get( 'onenter', '' );
		$onshiftenter 			= $this->params->get( 'onshiftenter', '' );
		$onctrlenter 			= $this->params->get( 'onctrlenter', '' );
		$onaltenter 			= $this->params->get( 'onaltenter', '' );
		$width 				= $this->params->get( 'width', '750' );
		$height 			= $this->params->get( 'height', '550' );
		$format 			= $this->params->get( 'format', '' );
		$encoding 			= $this->params->get( 'encoding', '' );
		$direction 			= $this->params->get( 'direction', '' );
		$toolbar 			= $this->params->get( 'toolbar', '' );
		$functions 			= $this->params->get( 'functions', '' );

		if ($onenter) { $onenter = "<" . $onenter . ">"; };
		if ($onshiftenter) { $onshiftenter = "<" . $onshiftenter . ">"; };
		if ($onctrlenter) { $onctrlenter = "<" . $onctrlenter . ">"; };
		if ($onaltenter) { $onaltenter = "<" . $onaltenter . ">"; };

		if (! $direction) {
			if ($language->isRTL()) {
				$direction = 'rtl';
			} else {
				$direction = 'ltr';
			}
		}

		// loading of css file for `styles` dropdown
		if (! $stylesheet) {
			/*
			 * Lets get the default template for the site application
			 */
			$query = 'SELECT template FROM #__templates_menu WHERE client_id = 0 AND menuid = 0';
			$db->setQuery( $query );
			$template = $db->loadResult();

			$file_path = JPATH_SITE .'/templates/'. $template .'/css/';
			if ( !file_exists( $file_path .DS. 'editor.css' ) ) {
				$template = 'system';
			}

			$stylesheet = JURI::root() .'templates/'. $template . '/css/editor.css",';
		}
		if (! $stylesheet) $stylesheet = $this->joomla_path.'/webeditor/example.css';

		// Only add "px" to width and height if they are not given as a percentage
		if (is_numeric( $width )) {
			$width .= 'px';
		}
		if (is_numeric( $height )) {
			$height .= 'px';
		}

		$buttons = $this->_displayButtons($name, $buttons);
		$editor  = "<textarea id=\"$name\" name=\"$name\" cols=\"$col\" rows=\"$row\" style=\"width:{$width}; height:{$height};\" class=\"mce_editable=\">$content</textarea>\n" . $buttons;

		$content = str_replace("&lt;", "<", $content);
		$content = str_replace("&gt;", ">", $content);
		$content = str_replace("&amp;", "&", $content);
		$content = str_replace("&nbsp;", " ", $content);
		$content = str_replace("&quot;", "\"", $content);

		$escaped_content = str_replace("SCRIPT", "SCR'+'IPT", str_replace("script", "scr'+'ipt", str_replace("\t", "\\t", str_replace("\n", "\\n", str_replace("\r", "\\r", str_replace("'", "\'", str_replace("\\", "\\\\", $content)))))));
		$hiddenField = $name;
		$hiddenField_editor = $hiddenField . "_editor";

		return <<<EOD
<script type="text/javascript">webeditor.baseHref = '/';</script>
<table width="100%" cellpadding="0" cellspacing="0" border="0"><tr><td>
<script type="text/javascript">WebEditorToolbar($toolbar);</script>
</td></tr></table>
<div id="AsbruWCE">
<script type="text/javascript">
webeditor.shortenLocalURLsSearch = false;
webeditor.shortenLocalURLsPath = false;
webeditor.shortenLocalURLsBase = false;
$functions
// MSIE7 may fail if web content editor is invoked inline - set timeout to wait for DOM to become ready
if (navigator.userAgent.indexOf("MSIE 7") >= 0) {
	window.setTimeout(
		function() {
			$hiddenField_editor = new WebEditor('$hiddenField', '$escaped_content', { container: 'AsbruWCE', rootpath: '$this->joomla_path/webeditor/', language: 'php', stylesheet: '$stylesheet', showhtml: true, manager: '$manager', onEnter: '$onenter', onShiftEnter: '$onshiftenter', onCtrlEnter: '$onctrlenter', onAltEnter: '$onaltenter', toolbar: '', width: '$width', height: '$height', format: '$format', encoding: '$encoding', direction: '$direction' } );
		}
		,10
	);
} else {
	$hiddenField_editor = new WebEditor('$hiddenField', '$escaped_content', { rootpath: '$this->joomla_path/webeditor/', language: 'php', stylesheet: '$stylesheet', showhtml: true, manager: '$manager', onEnter: '$onenter', onShiftEnter: '$onshiftenter', onCtrlEnter: '$onctrlenter', onAltEnter: '$onaltenter', toolbar: '', width: '$width', height: '$height', format: '$format', encoding: '$encoding', direction: '$direction' } );
}
</script>
</div>
<table width="100%" cellpadding="0" cellspacing="0" border="0"><tr><td>
<script type="text/javascript">WebEditorDOMInspector();</script>
</td></tr></table>
EOD;

	}

	function onGetInsertMethod($name)
	{
		$doc = & JFactory::getDocument();

		$js= "function jInsertEditorText( text, editor ) {
			WebEditorPasteContent(text, editor);
		}";
		$doc->addScriptDeclaration($js);

		return true;
	}

	function _displayButtons($name, $buttons)
	{
		// Load modal popup behavior
		JHTML::_('behavior.modal', 'a.modal-button');

		$args['name'] = $name;
		$args['event'] = 'onGetInsertMethod';

		$return = '';
		$results[] = $this->update($args);
		foreach ($results as $result) {
			if (is_string($result) && trim($result)) {
				$return .= $result;
			}
		}

		if(!empty($buttons))
		{
			$results = $this->_subject->getButtons($name, $buttons);

			/*
			 * This will allow plugins to attach buttons or change the behavior on the fly using AJAX
			 */
			$return .= "\n<div id=\"editor-xtd-buttons\">\n";
			foreach ($results as $button)
			{
				/*
				 * Results should be an object
				 */
				if ( $button->get('name') )
				{
					$modal		= ($button->get('modal')) ? 'class="modal-button"' : null;
					$href		= ($button->get('link')) ? 'href="'.JURI::base().$button->get('link').'"' : null;
					$onclick	= ($button->get('onclick')) ? 'onclick="'.$button->get('onclick').'"' : null;
					$return .= "<div class=\"button2-left\"><div class=\"".$button->get('name')."\"><a ".$modal." title=\"".$button->get('text')."\" ".$href." ".$onclick." rel=\"".$button->get('options')."\">".$button->get('text')."</a></div></div>\n";
				}
			}
			$return .= "</div>\n";
		}

		return $return;
	}
}
