<?php
/**
* @version $Id: bot_asbru.php,v 1.3 2007/06/13 16:25:59 admin Exp $
* @package Mambo
* @copyright (C) 2000 - 2005 Miro International Pty Ltd
* @license http://www.gnu.org/copyleft/gpl.html GNU/GPL
* Mambo is Free Software
*/

/** ensure this file is being included by a parent file */
defined( '_VALID_MOS' ) or die( 'Direct Access to this location is not allowed.' );

$_MAMBOTS->registerFunction( 'onInitEditor', 'botAsbruEditorInit' );
$_MAMBOTS->registerFunction( 'onGetEditorContents', 'botAsbruEditorGetContents' );
$_MAMBOTS->registerFunction( 'onEditorArea', 'botAsbruEditorEditorArea' );

/**
* Asbru Web Content Editor - javascript initialisation
*/
function botAsbruEditorInit() {
	return <<<EOD
<script type="text/javascript" src="/webeditor/webeditor.js"></script>
<script type="text/javascript">
function webeditor_custom_save() {
	submitbutton('save');
}
</script>
<style type="text/css">
table.adminform td .webeditor_toolbar td {
	padding: 0px;
}
</style>
EOD;
}
/**
* Asbru Web Content Editor - copy editor content to form field
*/
function botAsbruEditorGetContents( $editorArea, $hiddenField ) {
	return <<<EOD
WebEditorSubmit();
EOD;
}
/**
* Asbru Web Content Editor - display the editor
* @param string The name of the editor area
* @param string The content of the field
* @param string The name of the form field
* @param string The width of the editor area
* @param string The height of the editor area
* @param int The number of columns for the editor area
* @param int The number of rows for the editor area
*/
function botAsbruEditorEditorArea( $name, $content, $hiddenField, $width, $height, $col, $row ) {
	global $mosConfig_live_site, $database, $mosConfig_absolute_path;

	// load asbru info
	$query = "SELECT id FROM #__mambots WHERE (element = 'asbru' or element = 'bot_asbru') AND folder = 'editors'";
	$database->setQuery( $query );
	$id = $database->loadResult();
	$mambot = new mosMambot( $database );
	$mambot->load( $id );
	$params =& new mosParameters( $mambot->params );

	$stylesheet		= $params->def( 'stylesheet', '/webeditor/example.css' );
 	$manager 		= $params->def( 'manager', '' );
 	$onenter		= $params->def( 'onenter', '' );
 	$onshiftenter		= $params->def( 'onshiftenter', '' );
 	$onctrlenter		= $params->def( 'onctrlenter', '' );
 	$onaltenter		= $params->def( 'onaltenter', '' );
 	$width			= $params->def( 'width', '750' );
 	$height			= $params->def( 'height', '550' );
 	$format			= $params->def( 'format', '' );
 	$encoding		= $params->def( 'encoding', '' );
 	$direction		= $params->def( 'direction', '' );
	$toolbar 		= $params->def( 'toolbar', '' );
	$functions 		= $params->def( 'functions', '' );

	if ($onenter) { $onenter = "<" . $onenter . ">"; };
	if ($onshiftenter) { $onshiftenter = "<" . $onshiftenter . ">"; };
	if ($onctrlenter) { $onctrlenter = "<" . $onctrlenter . ">"; };
	if ($onaltenter) { $onaltenter = "<" . $onaltenter . ">"; };

	$content = str_replace("&lt;", "<", $content);
	$content = str_replace("&gt;", ">", $content);
	$content = str_replace("&amp;", "&", $content);
	$content = str_replace("&nbsp;", " ", $content);
	$content = str_replace("&quot;", "\"", $content);

	$escaped_content = str_replace("SCRIPT", "SCR'+'IPT", str_replace("script", "scr'+'ipt", str_replace("\t", "\\t", str_replace("\n", "\\n", str_replace("\r", "\\r", str_replace("'", "\'", str_replace("\\", "\\\\", $content)))))));
	$hiddenField_editor = $hiddenField . "_editor";

	return <<<EOD
<script type="text/javascript">webeditor.baseHref = '/';</script>
<table width="100%" cellpadding="0" cellspacing="0" border="0"><tr><td>
<script type="text/javascript">WebEditorToolbar($toolbar);</script>
</td></tr></table>
<div id="AsbruWCE">
<script type="text/javascript">
$functions
// MSIE7 may fail if web content editor is invoked inline - set timeout to wait for DOM to become ready
if (navigator.userAgent.indexOf("MSIE 7") >= 0) {
	window.setTimeout(
		function() {
			$hiddenField_editor = new WebEditor('$hiddenField', '$escaped_content', { container: 'AsbruWCE', rootpath: '/webeditor/', language: 'php', stylesheet: '$stylesheet', showhtml: true, manager: '$manager', onEnter: '$onenter', onShiftEnter: '$onshiftenter', onCtrlEnter: '$onctrlenter', onAltEnter: '$onaltenter', toolbar: '', width: '$width', height: '$height', format: '$format', encoding: '$encoding', direction: '$direction' } );
		}
		,10
	);
} else {
	$hiddenField_editor = new WebEditor('$hiddenField', '$escaped_content', { rootpath: '/webeditor/', language: 'php', stylesheet: '$stylesheet', showhtml: true, manager: '$manager', onEnter: '$onenter', onShiftEnter: '$onshiftenter', onCtrlEnter: '$onctrlenter', onAltEnter: '$onaltenter', toolbar: '', width: '$width', height: '$height', format: '$format', encoding: '$encoding', direction: '$direction' } );
}
</script>
</div>
<table width="100%" cellpadding="0" cellspacing="0" border="0"><tr><td>
<script type="text/javascript">WebEditorDOMInspector();</script>
</td></tr></table>
EOD;
}
?>
